<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewFieldsToPlans extends Migration
{
    public function up()
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->integer('trial_period')->nullable()->after('Price');
            $table->decimal('tax_amount', 10, 2)->nullable()->after('trial_period');
            $table->enum('type', ['basic', 'premium'])->default('basic')->after('Access_Level');
        });
    }

    public function down()
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->dropColumn(['trial_period', 'tax_amount', 'type']);
        });
    }
}
